/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts.table;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.util.DelayedListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class FeatureSummary
implements Feature {
    public static final String CTX_KEY_TEXT = "summary.text";
    private static final Set<Feature.Event> EVENTS = Collections.unmodifiableSet(new HashSet<Feature.Event>(Arrays.asList(Feature.Event.PAINT, Feature.Event.ADDED, Feature.Event.REFRESH, Feature.Event.REMOVED, Feature.Event.REMOVED_ALL)));
    private Listener listener = new DelayedListener(new UpdateListener());
    private Label summary = null;
    private String text = "";

    @Override
    public boolean onEvent(Feature.Event e) {
        return EVENTS.contains((Object)e);
    }

    @Override
    public void handleEvent(Feature.Event e, Feature.Context ctx) {
        if (this.summary == null && ctx.control != null) {
            this.summary = GUI.getStyleFactory().createLabel(ctx.control.getParent(), 0);
            this.summary.setLayoutData((Object)new GridData(768));
        }
        this.text = (String)ctx.addon.get(CTX_KEY_TEXT);
        this.listener.handleEvent(null);
    }

    private class UpdateListener
    implements Listener {
        private UpdateListener() {
        }

        public void handleEvent(Event event) {
            if (FeatureSummary.this.summary != null && !FeatureSummary.this.summary.isDisposed()) {
                FeatureSummary.this.summary.setText(FeatureSummary.this.text != null ? FeatureSummary.this.text : "");
            }
        }
    }
}

